﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.BMXNet.Model;
using System.Globalization;

namespace IndianHealthService.BMXNet.WinForm.Model
{
    internal class WinVisit : WinObject, Visit
    {
      
        private DateTime _dateTime;

        public DateTime DateTime
        {
            get { return _dateTime; }
            set { _dateTime = value; }
        }


        private String _locationName;

        public String LocationName
        {
            get { return _locationName; }
            set { _locationName = value; }
        }
        private String _clinic;

        public String Clinic
        {
            get { return _clinic; }
            set { _clinic = value; }
        }


        private String _visitType = null;

        public String VisitType
        {
            get { return _visitType; }
            set { _visitType = value; }
        }


        private String _providerName;

        public String ProviderName
        {
            get { return _providerName; }
            set { _providerName = value; }
        }

        public override string ToString()
        {
            return this.Label;
        }

        public String Label
        {

            get { return this.DateTime.ToShortDateString() + " " + this.Clinic + ", " + this.ProviderName; }
        }

        private String _serviceCategory = null;

        public String ServiceCategory
        {
            get { return _serviceCategory; }
            set { _serviceCategory = value; }
        }



        #region Visit Members


        public bool IsStub
        {
            get
            {
                return false;
            }
            set
            {
                
            }
        }

        public bool Create()
        {
            return this.Create(true);
        }

        public bool Create(bool showGuiToCreate)
        {
            return true;
        }

        public bool IsLocked
        {
            get
            {
                return false;
            }
            set
            {                
            }
        }

        public bool IsFutureAppointment
        {
            get { return false; }
        }


        #endregion
    }
}